﻿using UnityEngine;

[RequireComponent(typeof(BoxCollider)), DisallowMultipleComponent]
public class Boost : MonoBehaviour
{
    public Vector3 m_direction = Vector3.zero;
    public float m_multiplier = 1.0f;
    
    private Rigidbody m_collidedObject;
    private Vector3 m_worldDirection;
    
    void Update()
    {
        m_worldDirection = gameObject.transform.TransformVector(m_direction);
    }

    private void OnCollisionEnter(Collision other)
    {
        m_collidedObject = other.rigidbody;
    }

    private void OnCollisionExit(Collision other)
    {
        m_collidedObject = null;
    }

    private void FixedUpdate()
    {
        if (m_collidedObject != null)
        {
            var force = m_worldDirection * m_multiplier;
            m_collidedObject.AddForce(force);
        }
    }
}
